﻿Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.Text
Imports Accusoft.BarcodeXpressSdk

Module WriteBarcodes2DVB

    Sub Main(args As String())
        ' Set Barcode Type and Value from the command line arguments, defaulting to Data Matrix Barcode if none are provided.
        Dim barcodeValue As String = If(args.Length > 0, args(0), "Barcode Value")
        Dim barcodeType As BarcodeType = If(args.Length > 1, [Enum].Parse(GetType(BarcodeType), args(1), True), BarcodeType.DataMatrixBarcode)

        ' Create a new instance of the BarcodeXpress component.
        Using barcodeXpress As BarcodeXpress = New BarcodeXpress(".")
            ' The SetSolutionName, SetSolutionKey and possibly the SetOEMLicenseKey methods must be
            ' called to distribute the runtime.  Note that the SolutionName, SolutionKey and
            ' OEMLicenseKey values shown below are only examples.
            ' barcodeXpress.Licensing.SetSolutionName("YourSolutionName")
            ' barcodeXpress.Licensing.SetSolutionKey(1, 2, 3, 4)
            ' barcodeXpress.Licensing.SetOEMLicenseKey("YourOEMLicenseKey")

            ' Create a barcode using specific Barcode Xpress 2D writer.
            Select Case barcodeType
                Case BarcodeType.DataMatrixBarcode
                    Using dmWriter As WriterDataMatrix = New WriterDataMatrix(barcodeXpress)
                        CreateBarcode(dmWriter, barcodeValue)
                    End Using

                Case BarcodeType.PDF417Barcode
                    Using pdfWriter As WriterPDF417 = New WriterPDF417(barcodeXpress)
                        CreateBarcode(pdfWriter, barcodeValue)
                    End Using

                Case BarcodeType.QRCodeBarcode
                    Using qrWriter As WriterQRCode = New WriterQRCode(barcodeXpress)
                        CreateBarcode(qrWriter, barcodeValue)
                    End Using

                Case Else
                    Console.WriteLine("ERROR: Unsupported Barcode Type")
            End Select

        End Using

        Console.ReadLine()
        Console.WriteLine("Press enter to exit...")

    End Sub

    Sub CreateBarcode(writer As WriterBase, barcodeValue As String)
        If TypeOf writer Is WriterQRCode Then
            ' The input data for QR Code may contain Kanji characters.
            writer.BarcodeData = Encoding.UTF8.GetBytes(barcodeValue)
        Else
            writer.BarcodeValue = barcodeValue
        End If

        ' Create a Bitmap and save it to a local file.
        Using bitmap As Bitmap = writer.CreateBitmap()
            bitmap.Save("testfile.bmp", ImageFormat.Bmp)
            Console.WriteLine("Barcode image has been created successfully")
        End Using
    End Sub

End Module
