﻿Imports Accusoft.BarcodeXpressSdk

Module WriteBarcodes1DVB

    Sub Main()
        ' Create a new instance of the BarcodeXpress component.
        Dim bx As BarcodeXpress = New Accusoft.BarcodeXpressSdk.BarcodeXpress()

        ' The SetSolutionName, SetSolutionKey and possibly the SetOEMLicenseKey methods must be
        ' called to distribute the runtime.  Note that the SolutionName, SolutionKey and 
        ' OEMLicenseKey values shown below are only examples.
        ' bx.Licensing.SetSolutionName("YourSolutionName")
        ' bx.Licensing.SetSolutionKey(1, 2, 3, 4)
        ' bx.Licensing.SetOEMLicenseKey("2.0.AStringForOEMLicensingContactAccusoftSalesForMoreInformation...")

        ' Fetch command line arguments.
        Dim Arguments() As String = Environment.GetCommandLineArgs()

        ' Set Barcode Type and Value from the command line arguments, defaulting to Code 39 if none are provided.
        bx.writer.BarcodeValue = If(Arguments.Count() > 1, Arguments(1), "CODE 39")
        bx.writer.BarcodeType = If(Arguments.Count() > 2, [Enum].Parse(GetType(BarcodeType), Arguments(2)), BarcodeType.Code39Barcode)

        ' Create a Bitmap with BarcodeXpress
        Dim MyBitmap As System.Drawing.Bitmap = bx.writer.CreateBitmap()

        ' Save the created bitmap to a local file.
        MyBitmap.Save("testfile.bmp")
        Console.WriteLine("Barcode image has been created successfully")
        Console.WriteLine("Press enter to exit...")
        Console.ReadLine()
    End Sub

End Module
