﻿using Accusoft.BarcodeXpressSdk;
using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Text;

namespace WriteBarcodes2DCSharp
{
    class WriteBarcodes2DCSharp
    {
        static void Main(string[] args)
        {
            // Set Barcode Type and Value from the command line arguments, defaulting to Data Matrix Barcode if none are provided.
            string barcodeValue = args.Length > 0 ? args[0] : "Barcode Value";
            BarcodeType barcodeType = args.Length > 1 ? (BarcodeType)Enum.Parse(typeof(BarcodeType), args[1], true) : BarcodeType.DataMatrixBarcode;

            // Create a new instance of the BarcodeXpress component.
            using (BarcodeXpress barcodeXpress = new BarcodeXpress("."))
            {
                // The SetSolutionName, SetSolutionKey and possibly the SetOEMLicenseKey methods must be
                // called to distribute the runtime. Note that the SolutionName, SolutionKey and
                // OEMLicenseKey values shown below are only examples.
                // barcodeXpress.Licensing.SetSolutionName("YourSolutionName");
                // barcodeXpress.Licensing.SetSolutionKey(0x00000001, 0x00000002, 0x00000003, 0x00000004);
                // barcodeXpress.Licensing.SetOEMLicenseKey("YourOEMLicenseKey");

                // Create a barcode using specific Barcode Xpress 2d writer.
                switch (barcodeType)
                {
                    case BarcodeType.DataMatrixBarcode:
                        using (WriterDataMatrix dmWriter = new WriterDataMatrix(barcodeXpress))
                        {
                            CreateBarcode(dmWriter, barcodeValue);
                        }
                        break;
                    case BarcodeType.PDF417Barcode:
                        using (WriterPDF417 pdfWriter = new WriterPDF417(barcodeXpress))
                        {
                            CreateBarcode(pdfWriter, barcodeValue);
                        }
                        break;
                    case BarcodeType.QRCodeBarcode:
                        using (WriterQRCode qrWriter = new WriterQRCode(barcodeXpress))
                        {
                            CreateBarcode(qrWriter, barcodeValue);
                        }
                        break;
                    default:
                        Console.WriteLine("ERROR: Unsupported Barcode Type");
                        break;
                }
            }
            Console.WriteLine("Press enter to exit...");
            Console.ReadLine();
        }

        static void CreateBarcode(WriterBase writer, string barcodeValue)
        {
            if (writer is WriterQRCode)
                // The input data for QR Code may contain Kanji characters.
                writer.BarcodeData = Encoding.UTF8.GetBytes(barcodeValue);
            else
                writer.BarcodeValue = barcodeValue;

            // Create a Bitmap and save it to a local file.
            using (Bitmap bitmap = writer.CreateBitmap())
            {
                bitmap.Save("testfile.bmp", ImageFormat.Bmp);
                Console.WriteLine("Barcode image has been created successfully");
            }
        }
    }
}
