using Accusoft.BarcodeXpressSdk;
using Newtonsoft.Json;
using System;
using System.Drawing;
using System.Reflection;

namespace ReadBarcodes
{
    class ReadBarcodesCSharp
    {
        // Takes an argument for an image path, then prints out any barcodes found on that image.
        static void Main(string[] args)
        {
            string imagePath = (args.Length > 0) ? args[0] : System.IO.Path.GetDirectoryName(Assembly.GetEntryAssembly().Location) + @"\..\..\..\..\images\Barcode-All-Supported-Types.bmp";
            // Search all types of barcodes in an image file (by default all 1D barcodes).
            // For the full list of options, see the API reference
            // at https://help.accusoft.com/BarcodeXpress/latest/BxNet/webframe.html#API_Reference.html
            using (BarcodeXpress barcodeXpress = new BarcodeXpress("."))
            using (Bitmap bitmap = new Bitmap(imagePath))
            {
                // The SetSolutionName, SetSolutionKey and possibly the SetOEMLicenseKey method must be
                // called to distribute the runtime.  Note that the SolutionName, SolutionKey and 
                // OEMLicenseKey values shown below are only examples.
                //barcodeXpress.Licensing.SetSolutionName("YourSolutionName");
                //barcodeXpress.Licensing.SetSolutionKey(12345, 12345, 12345, 12345);
                //barcodeXpress.Licensing.SetOEMLicenseKey("1.0.AStringForOEMLicensingContactAccusoftSalesForMoreInformation...");
                
                barcodeXpress.reader.BarcodeTypes = Enum.GetValues(typeof(BarcodeType));

                Accusoft.BarcodeXpressSdk.Result[] results = barcodeXpress.reader.Analyze(bitmap);

                Console.WriteLine("Results:");
                Console.WriteLine(JsonConvert.SerializeObject(results, Formatting.Indented));
                Console.WriteLine("Press enter to exit...");
                Console.ReadLine();
            }
        }
    }
}
