﻿using System;
using Accusoft.BarcodeXpressSdk;

namespace WriteBarcodes1DCSharp
{
    class WriteBarcodes1DCSharp
    {
        static void Main(string[] args)
        {
            // Create a new instance of the BarcodeXpress component.
            using (BarcodeXpress bx = new BarcodeXpress("."))
            {
                // The SetSolutionName, SetSolutionKey and possibly the SetOEMLicenseKey methods must be
                // called to distribute the runtime.  Note that the SolutionName, SolutionKey and 
                // OEMLicenseKey values shown below are only examples.
                //bx.Licensing.SetSolutionName("YourSolutionName");
                //bx.Licensing.SetSolutionKey(1, 2, 3, 4);
                //bx.Licensing.SetOEMLicenseKey("2.0.AStringForOEMLicensingContactAccusoftSalesForMoreInformation...");

                // Set Barcode Type and Value from the command line arguments, defaulting to Code 39 if none are provided.
                bx.writer.BarcodeValue = (args.Length > 0) ? args[0] : "CODE39";
                bx.writer.BarcodeType = (args.Length > 1) ? (BarcodeType)Enum.Parse(typeof(BarcodeType), args[1]) : BarcodeType.Code39Barcode;

                // Create a Bitmap with Barcode Xpress.
                System.Drawing.Bitmap bitmap = bx.writer.CreateBitmap();

                // Save the created bitmap to a local file.
                bitmap.Save("testfile.bmp");
                bitmap.Dispose();
            }
           
            Console.WriteLine("Barcode image has been created successfully");
        }
    }
}
