###################################################################
# Copyright 2002-2025 Accusoft Corporation, Tampa Florida.        #
# This sample code is provided to Accusoft licensees "as is"      #
# with no restrictions on use or modification. No warranty for    #
# use of this sample code is provided by Accusoft.                #
###################################################################
# BarcodeXpress readbarcodes sample:
# This sample program demonstrates the reader API for BarcodeXpress:
#   - It reads each image passed in to the command line.

import cv2
import BarcodeXpress
import argparse

if __name__ == "__main__":
    # Set the environment variable for the location of Accusoft licenses.
    # If this variable is not set, then the license file must be located in one 
    # of the standard locations as specified in the help file.

    # Set Barcode Xpress Runtime Licensing:
    # These methods should only be called if this application is deployed on a 
    # machine with a runtime license installed. See the online help for 
    # information about how to install a runtime license. If this is a 
    # development machine, then there is no need to call the licensing 
    # functions; An evaluation or development license will be used.

    # BarcodeXpress.SetSolutionName("YourSolutionName")
    # BarcodeXpress.SetSolutionKey(key1, key2, key3, key4)
    # BarcodeXpress.SetOEMLicenseKey("2.0.AStringForOEMLicensingContactAccusoftSalesForMoreInformation...")
    
    parser = argparse.ArgumentParser()
    parser.add_argument('images', nargs="+", help="Images to be scanned for barcodes.")
    args = parser.parse_args()

    for image in args.images:
        print("Analyzing image " + image)
        
        image_data = cv2.imread(image, cv2.IMREAD_GRAYSCALE)
        
        results = BarcodeXpress.AnalyzeOpenCV(image_data, {
            "Orientation": BarcodeXpress.Orientation.HorizontalVerticalDiagonal,
            "BarcodeTypes": [BarcodeXpress.BarcodeType.All]
        })

        if len(results) < 1:
            print("No results")
        else:
            for i in range(0, len(results)):
                print("\tResult #" + str(i + 1))
                print("\t\tBarcode Type: " + results[i].Name)
                print("\t\tValue: " + results[i].Value)
                print("\t\tConfidence: " + str(results[i].Confidence) + "\n")

        print("")

                

