/*******************************************************************
 * Copyright 2002-2023 Accusoft Corporation, Tampa Florida.        *
 * This sample code is provided to Accusoft licensees "as is"      *
 * with no restrictions on use or modification. No warranty for    *
 * use of this sample code is provided by Accusoft.                *
 *******************************************************************
 * BarcodeXpress readbarcodes sample:
 * This sample program demonstrates the reader API for BarcodeXpress:
 *   - It reads each .BMP file passed in to the command line.
 */

#include <linux/limits.h>
#include "barcodexpress.h"
#include "stdlib.h"
#include "stdio.h"

void setupLicense( ) {
    // Set the environment variable for the location of Accusoft licenses.
    // If this variable is not set, then the license file must be located in one of the
    // standard locations as specified in the help file.
    // char *licensePath = "/custom/path/to/license/file";
    // setenv( "ACCUSOFT_LICENSE_DIR", licensePath, 1 );

    /*
    * Set Barcode Xpress Runtime Licensing:
    * These methods should only be called if this application is deployed on a machine with a runtime license installed.
    * See the help file for information about how to install a runtime license.
    * If this is a development machine, then there is no need to call the licensing functions.
    * An evaluation or development license will be used.
    */

    // BX_set_solution_name("YourSolutionName");
    // BX_set_solution_key(key1, key2, key3, key4);
    // BX_set_oem_license_key("2.0.AStringForOEMLicensingContactAccusoftSalesForMoreInformation...");
}

void analyzeImage(const char* fileName) {
    printf("Analyzing image %s\n", fileName);

    BX_AnalyzeParameters params = BX_DefaultAnalyzeParameters;
    BX_AnalyzeResult result;
    BX_Status status;

    params.BarcodeTypes = BX_BarcodeType_All;
    params.Orientation = BX_Orientation_HorizontalVerticalDiagonal;
    
    status = BX_analyze_file( &params, fileName, &result );
    
    if( BX_Status_OK != status ) {
        printf("ERRORS:\n");
        for( int i=0; i<result.ErrorCount; ++i ) {
            BX_Error *error = &(result.BarcodeErrors[i]);
            printf("\t%d: %s\n\t%s\n", error->ErrorStatus, error->ErrorID, error->ErrorMessage);
        }
        return;
    }

    if( 0 == result.BarcodeResultsLength ) {
        printf("No results\n");
        BX_free_analyze_result( &result );
        return;
    }

    for( int i=0; i<result.BarcodeResultsLength; ++i ) {
        BX_BarcodeResult *res = &result.BarcodeResults[i];
        printf("\tResult #%d\n", i+1);
        printf("\t\tBarcode Type: %s\n", res->Name);
        printf("\t\tValue: %s\n", res->Value);
        printf("\t\tConfidence: %ld\n\n", res->Confidence);
    }

    BX_free_analyze_result( &result );
}

int main(const int argc, const char **argv) {
    if( argc < 2 ) {
        printf("Usage: readbarcodes [filename [filename [...]]]\n");
        return -1;
    }

    setupLicense( );
    
    for(int i=1; i<argc; ++i) {
        analyzeImage( argv[i] );
        printf("\n");
    }

    return 0;
}