#!/bin/bash

if type -p java; then
    _java=java
elif [[ -n "$JAVA_HOME" ]] && [[ -x "$JAVA_HOME/bin/java" ]];  then
    _java="$JAVA_HOME/bin/java"
else
    echo "Java is not installed."
fi

if [[ "$_java" ]]; then
    echo "Running eval license manager"
    version=$("$_java" -version 2>&1 | awk -F '"' '/version/ {print $2}')
    echo Java version "$version"
    if [[ "${version:0:2}" == "1." && "${version:2:3}" < "8" ]]; then
        echo "License manager requires Java 1.8 or greater to run."
    else
        java -jar licensemanager.jar
    fi
fi

