/*
 * Decompiled with CFR 0.152.
 */
package com.accusoft.barcodexpress;

import com.accusoft.barcodexpress.BarcodeException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

final class Dib {
    Dib() {
    }

    private static int getStridePadded(int width, int bpp) {
        if (bpp == 1) {
            return (width + 7 >> 3) + 3 & 0xFFFFFFFC;
        }
        return (bpp >> 3) * width + 3 & 0xFFFFFFFC;
    }

    private static int getStrideUnpadded(int width, int bpp) {
        if (bpp == 1) {
            return width + 7 >> 3;
        }
        return (bpp >> 3) * width;
    }

    private static DibInfo getDibInfo(BufferedImage image) throws BarcodeException {
        int bpp;
        Raster data = image.getData();
        int type = image.getType();
        switch (type) {
            case 12: {
                bpp = 1;
                break;
            }
            case 10: 
            case 13: {
                bpp = 8;
                break;
            }
            case 5: {
                bpp = 24;
                break;
            }
            case 1: {
                bpp = 32;
                break;
            }
            default: {
                throw new BarcodeException("Unsupported image format: BufferedImage type of " + type + " is unsupported");
            }
        }
        byte[] pixelData = new byte[]{};
        int[] paletteData = new int[]{};
        if (32 == bpp) {
            int[] rawBuffer = ((DataBufferInt)data.getDataBuffer()).getData();
            ByteBuffer byteBuffer = ByteBuffer.allocate(rawBuffer.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            intBuffer.put(rawBuffer);
            pixelData = byteBuffer.array();
        } else {
            ColorModel colorModel;
            pixelData = ((DataBufferByte)data.getDataBuffer()).getData();
            if (type == 13) {
                colorModel = image.getColorModel();
                IndexColorModel indexColorModel = null;
                if (colorModel instanceof IndexColorModel) {
                    indexColorModel = (IndexColorModel)colorModel;
                    int rgbSize = indexColorModel.getMapSize();
                    int[] rgbs = new int[rgbSize];
                    indexColorModel.getRGBs(rgbs);
                    paletteData = rgbs;
                }
            } else if (type == 12) {
                colorModel = image.getColorModel();
                if (colorModel.getPixelSize() != 1) {
                    throw new BarcodeException("Unsupported image format: BufferedImage type of BYTE_BINARY depth of " + colorModel.getPixelSize() + " bpp unsupported");
                }
                IndexColorModel indexColorModel = null;
                if (colorModel instanceof IndexColorModel) {
                    indexColorModel = (IndexColorModel)colorModel;
                    int rgbSize = indexColorModel.getMapSize();
                    int[] rgbs = new int[rgbSize];
                    indexColorModel.getRGBs(rgbs);
                    paletteData = rgbs;
                }
            }
        }
        DibInfo info = new DibInfo();
        info.pixelData = pixelData;
        info.paletteData = paletteData;
        info.width = data.getWidth();
        info.height = data.getHeight();
        info.bpp = bpp;
        return info;
    }

    public static byte[] fromBufferedImage(BufferedImage image) throws BarcodeException {
        int outBpp;
        DibInfo dibInfo = Dib.getDibInfo(image);
        switch (dibInfo.bpp) {
            case 1: 
            case 8: 
            case 24: 
            case 32: {
                outBpp = dibInfo.bpp;
                break;
            }
            default: {
                throw new BarcodeException("Unexpected DIB bpp: " + dibInfo.bpp);
            }
        }
        int stride = Dib.getStridePadded(dibInfo.width, outBpp);
        int paletteColors = outBpp < 24 ? 1 << outBpp : 0;
        ByteBuffer outBuffer = ByteBuffer.allocate(40 + 4 * paletteColors + stride * dibInfo.height);
        outBuffer.order(ByteOrder.LITTLE_ENDIAN);
        outBuffer.putInt(40);
        outBuffer.putInt(dibInfo.width);
        outBuffer.putInt(dibInfo.height);
        outBuffer.putShort((short)1);
        outBuffer.putShort((short)outBpp);
        outBuffer.putInt(0);
        outBuffer.putInt(stride * dibInfo.height);
        outBuffer.putInt(0);
        outBuffer.putInt(0);
        outBuffer.putInt(paletteColors);
        outBuffer.putInt(0);
        if (dibInfo.paletteData.length > 0) {
            for (int i = 0; i < dibInfo.paletteData.length; ++i) {
                outBuffer.putInt(dibInfo.paletteData[i]);
            }
        } else {
            for (int i = 0; i < paletteColors; ++i) {
                int c = 255 * i / (paletteColors - 1);
                int rgb = c << 16 | c << 8 | c;
                outBuffer.putInt(rgb);
            }
        }
        outBuffer.put(Dib.convertToPaddedDIB(dibInfo));
        return outBuffer.array();
    }

    private static byte[] convertToPaddedDIB(DibInfo info) {
        int width = info.width;
        int height = info.height;
        int inBpp = info.bpp;
        int strideIn = Dib.getStrideUnpadded(width, inBpp);
        int strideOut = Dib.getStridePadded(width, inBpp);
        byte[] outBuffer = new byte[strideOut * height];
        int xInc = inBpp != 1 ? 1 : 8;
        int bytesPerPixel = (inBpp + 7) / 8;
        for (int y = 0; y < height; ++y) {
            int inOffset = (height - 1 - y) * strideIn;
            int outOffset = y * strideOut;
            for (int x = 0; x < width; x += xInc) {
                for (int _byte = 0; _byte < bytesPerPixel; ++_byte) {
                    outBuffer[outOffset++] = info.pixelData[inOffset++];
                }
            }
        }
        return outBuffer;
    }

    private static class DibInfo {
        public byte[] pixelData;
        public int[] paletteData;
        public int width;
        public int height;
        public int bpp;
    }
}

