/*
 * Decompiled with CFR 0.152.
 */
package com.accusoft.barcodexpress;

import com.accusoft.barcodexpress.BarcodeReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public final class BarcodeXpress {
    static final String versionMajor = "14";
    static final String versionMinor = "0";
    private BarcodeReader reader = new BarcodeReader();

    private static void extractLibraries() throws IOException {
        String bxLib = null;
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("win") >= 0) {
            bxLib = BarcodeXpress.extractFromJar("lib/Accusoft.BarcodeXpress14.Java64.dll");
        } else if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") >= 0) {
            bxLib = BarcodeXpress.extractFromJar("lib/libbarcodexpressjava.so.14.0");
        }
        if (null == bxLib) {
            throw new IOException("Couldn't load BarcodeExpress native library for '" + OS + "'");
        }
        System.load(bxLib);
        BarcodeXpress.initialize();
    }

    private static void copyInputStreamToFile(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String extractFromJar(String jarFileName) throws IOException {
        ClassLoader bxClassLoader = BarcodeXpress.class.getClassLoader();
        URL url = bxClassLoader.getResource(jarFileName);
        if (url.getProtocol().compareToIgnoreCase("file") == 0) {
            return url.getPath();
        }
        InputStream inStream = bxClassLoader.getResourceAsStream(jarFileName);
        if (null == inStream) {
            throw new IOException("Couldn't load native resource: " + jarFileName);
        }
        try {
            File outFile = File.createTempFile("libbarcodexpressjava", ".so");
            outFile.deleteOnExit();
            if (!outFile.exists()) {
                return null;
            }
            BarcodeXpress.copyInputStreamToFile(inStream, outFile);
            inStream.close();
            return outFile.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static native void initialize();

    public static native void setSolutionName(String var0);

    public static native void setSolutionKey(int var0, int var1, int var2, int var3);

    public static native void setOemLicenseKey(String var0);

    public BarcodeReader getReader() {
        return this.reader;
    }

    static {
        try {
            BarcodeXpress.extractLibraries();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

