/*
 * Decompiled with CFR 0.152.
 */
package com.accusoft.barcodexpress;

public enum BarcodeType {
    INDUSTRY2OF5,
    INTERLEAVED2OF5,
    IATA2OF5,
    DATALOGIC2OF5,
    INVERTED2OF5,
    BCDMATRIX,
    MATRIX2OF5,
    CODE32,
    CODE39,
    CODABAR,
    CODE93,
    CODE128,
    EAN13,
    EAN8,
    UPCA,
    UPCE,
    ADD5,
    ADD2,
    EAN128,
    PATCHCODE,
    POSTNET,
    PDF417,
    DATAMATRIX,
    CODE39EXTENDED,
    CODE93EXTENDED,
    QRCODE,
    INTELLIGENTMAIL,
    ROYALPOST4STATE,
    AUSTRALIANPOST4STATE,
    AZTEC,
    GS1DATABAR,
    UPU4STATE,
    MICROPDF417,
    PLANET,
    MICROQRCODE,
    UNKNOWN,
    ALL1D,
    ALL2D,
    ALL;


    static long getMask(BarcodeType _type) {
        if (_type == UNKNOWN) {
            return 0L;
        }
        if (_type == ALL1D) {
            return BarcodeType.getMask(ADD2) | BarcodeType.getMask(ADD5) | BarcodeType.getMask(AUSTRALIANPOST4STATE) | BarcodeType.getMask(BCDMATRIX) | BarcodeType.getMask(CODABAR) | BarcodeType.getMask(CODE32) | BarcodeType.getMask(CODE39) | BarcodeType.getMask(CODE39EXTENDED) | BarcodeType.getMask(CODE93) | BarcodeType.getMask(CODE93EXTENDED) | BarcodeType.getMask(CODE128) | BarcodeType.getMask(DATALOGIC2OF5) | BarcodeType.getMask(EAN8) | BarcodeType.getMask(EAN13) | BarcodeType.getMask(EAN128) | BarcodeType.getMask(GS1DATABAR) | BarcodeType.getMask(IATA2OF5) | BarcodeType.getMask(INDUSTRY2OF5) | BarcodeType.getMask(INTELLIGENTMAIL) | BarcodeType.getMask(INTERLEAVED2OF5) | BarcodeType.getMask(INVERTED2OF5) | BarcodeType.getMask(MATRIX2OF5) | BarcodeType.getMask(PATCHCODE) | BarcodeType.getMask(POSTNET) | BarcodeType.getMask(ROYALPOST4STATE) | BarcodeType.getMask(UPCA) | BarcodeType.getMask(UPCE) | BarcodeType.getMask(PLANET) | BarcodeType.getMask(UPU4STATE);
        }
        if (_type == ALL2D) {
            return BarcodeType.getMask(AZTEC) | BarcodeType.getMask(DATAMATRIX) | BarcodeType.getMask(PDF417) | BarcodeType.getMask(QRCODE) | BarcodeType.getMask(MICROPDF417) | BarcodeType.getMask(MICROQRCODE);
        }
        if (_type == ALL) {
            return BarcodeType.getMask(ALL1D) | BarcodeType.getMask(ALL2D);
        }
        return 1L << _type.ordinal();
    }
}

