/*
 * Decompiled with CFR 0.152.
 */
package com.accusoft.barcodexpress;

import com.accusoft.barcodexpress.BarcodeException;
import com.accusoft.barcodexpress.BarcodeType;
import com.accusoft.barcodexpress.Dib;
import com.accusoft.barcodexpress.Orientation;
import com.accusoft.barcodexpress.Result;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public final class BarcodeReader {
    private BarcodeType[] _barcodeTypes = new BarcodeType[]{BarcodeType.ALL};
    private Rectangle _area;
    private Orientation _orientation = Orientation.HORIZONTALVERTICAL;
    private int _scanDistance = 5;
    private boolean _additionalReadingPass = false;
    private boolean _code39StartStopPatternsAreMandatory = true;
    private boolean _royalMailVariableLengthDecoding = false;

    BarcodeReader() {
        this._area = new Rectangle(0, 0, 0, 0);
    }

    private native Result[] _analyze(byte[] var1);

    public Result[] analyze(BufferedImage image) throws BarcodeException {
        byte[] dib = Dib.fromBufferedImage(image);
        return this._analyze(dib);
    }

    public BarcodeType[] getBarcodeTypes() {
        return this._barcodeTypes;
    }

    public void setBarcodeTypes(BarcodeType[] _types) {
        this._barcodeTypes = _types;
    }

    public Rectangle getArea() {
        return this._area;
    }

    public void setArea(Rectangle area) {
        this._area = area;
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setOrientation(Orientation orientation) {
        this._orientation = orientation;
    }

    public int getScanDistance() {
        return this._scanDistance;
    }

    public void setScanDistance(int scanDistance) {
        this._scanDistance = scanDistance;
    }

    public boolean getRoyalMailVariableLengthDecoding() {
        return this._royalMailVariableLengthDecoding;
    }

    public void setRoyalMailVariableLengthDecoding(boolean royalMailVariableLengthDecoding) {
        this._royalMailVariableLengthDecoding = royalMailVariableLengthDecoding;
    }

    public boolean getAdditionalReadingPass() {
        return this._additionalReadingPass;
    }

    public void setAdditionalReadingPass(boolean additionalReadingPass) {
        this._additionalReadingPass = additionalReadingPass;
    }

    public boolean getCode39StartStopPatternsAreMandatory() {
        return this._code39StartStopPatternsAreMandatory;
    }

    public void setCode39StartStopPatternsAreMandatory(boolean code39StartStopPatternsAreMandatory) {
        this._code39StartStopPatternsAreMandatory = code39StartStopPatternsAreMandatory;
    }
}

